shape = {}

function shape.Calculate()
   Circle(0, 0, shape.od)
   
   if shape.ctrShape == 0 then --round
      Circle(0,0,shape.id)
   elseif shape.ctrShape == 1 then --square
      local s = shape.id / 2
      Line(-s, -s, -s, s)
      LineTo(s,s)
      LineTo(s,-s)
      LineTo(-s,-s)
   end
   local inc = ( 2 * math.pi) / shape.nHoles
   local ang = 0
   local pcd = shape.pcd / 2
   for ct=1, shape.nHoles do
      local x = math.sin(ang) * pcd
      local y = math.cos(ang) * pcd
      Circle(x, y, shape.holeDia)
      ang = ang + inc
   end
end

AddNumControl("od", "Outer diameter", sc.unitLINEAR, 50, 0.1, 10000, "od.png")
AddNumControl("pcd", "PCD", sc.unitLINEAR, 75, 0.1, 10000, "pcd.png")
AddNumControl("nHoles", "Number of holes", sc.unit0DECPLACE, 4, 1, 10000, "nholes.png")
AddNumControl("holeDia", "Hole diameter", sc.unitLINEAR, 10, 0.1, 10000, "holedia.png")
AddChoiceControl("ctrShape", "Centre hole shape", {"Round","Square","None"}, "")
AddNumControl("id", "Centre hole size", sc.unitLINEAR, 100, 0.1, 10000, "id.png")

